function hl = honl_london_allmixed_hfs(Sigma_A, Omega_A, J_A, J_X, I, F_A, F_X)

%% Calculates the square-root of the hl-factor

% Assumptions
Sigma_X = 1/2;
Omega_X = Sigma_X;
S_X = 0.5;
S_A = 0.5;

tr = 0;
for q = [-1 1]
    
    tr = tr + eq(Sigma_A, Sigma_X)*(-1)^(-Omega_A)*...
        Wigner3j([J_A 1 J_X],[-Omega_A q Omega_X])...
        + eq(Sigma_A, -Sigma_X)*(-1)^(J_X-S_X-Omega_A)*...
        Wigner3j([J_A 1 J_X],[-Omega_A q -Omega_X])...
        - eq(-Sigma_A, Sigma_X)*(-1)^(J_A-S_A+Omega_A)*...
        Wigner3j([J_A 1 J_X],[Omega_A q Omega_X])...
        - eq(-Sigma_A, -Sigma_X)*(-1)^(J_X - S_X + J_A - S_A + Omega_A)*...
        Wigner3j([J_A 1 J_X],[Omega_A q -Omega_X]);
    
end

hl = tr*0.5*sqrt(2*J_X + 1)*sqrt(2*J_A + 1)*sqrt(2*F_X + 1)*...
    Wigner6j(J_A, F_A, I, F_X, J_X, 1); % Pre-factor for Honl-London 

end